<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:ca="http://reference.niem.gov/niem/resource/mpd/catalog/3.0.1/"
    xmlns:nc="http://release.niem.gov/niem/niem-core/4.0/">

	<xsl:output method="html" encoding="UTF-8" indent="yes"/>
<!-- 
	<xsl:strip-space elements="*"/>
 -->	
	<xsl:template match="/">
		<xsl:apply-templates select="ca:Catalog/ca:MPD"/>
	</xsl:template>
	
	<xsl:template match="ca:MPD">
		
		<html>
			<head>
				<title><xsl:value-of select="@ca:mpdName"/></title>
			</head>
			<body>
				<xsl:call-template name="start">
					<xsl:with-param name="data" select="."/>
				</xsl:call-template>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="start">
		<xsl:param name="data"/>

		<div id="body">
    		<div id="intro">
				<h1><xsl:value-of select="$data/nc:DescriptionText"/></h1>
			    <table width="100%" border="1" style="border-collapse:collapse">
					<thead style="background-color:midnightblue; color:white; ">
					    <tr>
							<th>Attribute</th>
							<th>Value</th>
					    </tr>
					</thead>
					<tr>
					    <td>URI</td>
						<td><xsl:value-of select="$data/@ca:mpdURI" /></td>
					</tr>
					<tr>
					    <td>Class</td>
						<td>
							<xsl:value-of select="$data/@ca:mpdClassURIList"/>
						</td>
					</tr>
					<tr>
					    <td>Name</td>
						<td><xsl:value-of select="$data/@ca:mpdName" /></td>
					</tr>
					<tr>
					    <td>Version</td>
						<td><xsl:value-of select="$data/@ca:mpdVersionID" /></td>
					</tr>
					<tr>
					    <td>Description</td>
						<td><xsl:value-of select="$data/nc:DescriptionText" /></td>
					</tr>
			    </table>
    		</div>
		
			<div id="artifacts">
			    <h2>IEPD Artifacts</h2>
			
			    <table width="100%" border="1" style="border-collapse:collapse">
					<thead style="background-color:midnightblue; color:white; ">
					    <tr>
						<th>Artifact Purpose</th>
						<th>Path and File Name</th>
						<th>Description</th>
					    </tr>
					</thead>
				     
			    	<xsl:for-each select="$data/*">
				        <xsl:call-template name="put-row">
				          <xsl:with-param name="item" select="."/>
				        </xsl:call-template>
				    </xsl:for-each>
				</table>
			</div>
		
			<div id="metadata">
			    <h2>Metadata</h2>
			
			    <table width="100%" border="1" style="border-collapse:collapse">
			      <thead style="background-color:midnightblue; color:white; ">
						<tr>
							<th>Attribute</th>
							<th>Value</th>
						</tr>
			      </thead>
			      <tr>
					<td>Creation Date</td>
			      	<td><xsl:value-of select="$data/ca:MPDInformation/ca:CreationDate"/></td>
			      </tr>
			    	<xsl:for-each select="$data/ca:MPDInformation/ca:DomainText">
						<tr>
							 <td>Domain</td>
							 <td><xsl:value-of select="."/></td>
						</tr>
			      </xsl:for-each>
			      <tr>
					  <td>Purpose</td>
					  <td>    
					  	<xsl:value-of select="$data/ca:MPDInformation/ca:PurposeText"/>
					  </td>
			      </tr>
					<tr>
						 <td>Exchange Pattern</td>
						 <td>
						 	<xsl:for-each select="$data/ca:MPDInformation/ca:ExchangePatternText">
								<xsl:value-of select="."/>
								<xsl:if test="position() != last()">, </xsl:if>
							 </xsl:for-each>
						 </td>
					</tr>
			    </table>
			</div>
		
			<div id="source">
			    <h2>Authoritative Source</h2> 
			
			    <table width="100%" border="1" style="border-collapse:collapse">
					<thead style="background-color:midnightblue; color:white; ">
					    <tr>
						<th>Attribute</th>
						<th>Value</th>
					    </tr>
					</thead>
					<tr>
					    <td>Name</td>
					    <td>
					    	<xsl:value-of select="$data/ca:MPDInformation/ca:AuthoritativeSource/nc:EntityOrganization/nc:OrganizationName"/>
					    </td>
					</tr>
					<tr>
					    <td>Address</td>
						<td>
							<xsl:value-of select="$data/ca:MPDInformation/ca:AuthoritativeSource/nc:EntityOrganization/nc:OrganizationLocation/nc:Address/nc:AddressFullText"/>
						</td>
					</tr>
			    	<xsl:for-each select="$data/ca:MPDInformation/ca:AuthoritativeSource/nc:EntityOrganization/nc:OrganizationPrimaryContactInformation">
			    		<tr>
						    <td>Web Site</td>
						    <td>
						    	<a href="{nc:ContactWebsiteURI}">
						    		<xsl:value-of select="nc:ContactWebsiteURI"/>
								</a>
						    </td>
						</tr>
					    <tr>
							<td>Point of Contact</td>
							<td>
							    <!--<xsl:value-of select="ca:POCName"/>, -->
								<xsl:value-of select="nc:ContactEmailID"/> 
							    <!--,<xsl:value-of select="ca:POCTelephone"/>-->
							</td>
					    </tr>
			    	</xsl:for-each>
			    </table>
			</div>
    	</div>
	</xsl:template>
	
	<xsl:template name="put-row">
		<xsl:param name="item"/>
		<xsl:variable name="mediaType">
			<xsl:choose>
				<xsl:when test="$item/@ca:mimeMediaTypeText">
					<xsl:value-of select="$item/@ca:mimeMediaTypeText"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'none'"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="itemName" select="name($item)"/>
		<xsl:choose>
			<xsl:when test="contains($itemName, 'MPDInformation')">
				<!-- not processing this element -->
			</xsl:when>
			<xsl:when test="contains($itemName, 'DescriptionText')">
				<!-- not processing this element -->
			</xsl:when>
			<xsl:when test="contains($itemName, 'IEPConformanceTarget')">
				<xsl:for-each select="*">
					<!-- if not description text, then continue -->
					<xsl:if test="not(contains(name(.), 'DescriptionText'))">
						<xsl:choose>
							<!-- if contains schema valid, get the elements inside it -->
							<xsl:when test="contains(name(.), 'XMLSchemaValid')">
								<xsl:for-each select="*">
									<xsl:call-template name="put-row">
										<xsl:with-param name="item" select="."/>
									</xsl:call-template>			
								</xsl:for-each>
							</xsl:when>
							<!-- otherwise, get all elements under conformance target -->
							<xsl:otherwise>
								<xsl:call-template name="put-row">
									<xsl:with-param name="item" select="."/>
								</xsl:call-template>			
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<tr>
					<td>
						<xsl:choose>
							<xsl:when test="contains($itemName,'ReadMe')">Read Me</xsl:when>
							<xsl:when test="contains($itemName,'MPDChangeLog')">Change Log</xsl:when>
							<xsl:when test="contains($itemName,'Wantlist')">Subset Want List</xsl:when>
							<xsl:when test="contains($itemName,'ConformanceAssertion')">Conformance Assertion</xsl:when>
							<xsl:when test="contains($itemName,'ReferenceSchemaDocument')">Reference Schema</xsl:when>
							<xsl:when test="contains($itemName,'ExternalSchemaDocument')">External Schema</xsl:when>
							<xsl:when test="contains($itemName,'XMLSchemaDocument')">Exchange Schema</xsl:when>
							<xsl:when test="contains($itemName,'SubsetSchemaDocument')">Subset Schema</xsl:when>
							<xsl:when test="contains($itemName,'SchemaDocumentSet')">Subset Schema Set</xsl:when>
							<xsl:when test="contains($itemName,'XMLCatalog')">Catalog</xsl:when>
							<xsl:when test="contains($itemName,'IEPSampleXMLDocument')">Sample Instance</xsl:when>
							<xsl:when test="contains($itemName,'Documentation') or contains($itemName,'File')">
								<xsl:choose>
									<xsl:when test="contains($mediaType,'mpd-catalog')">Catalog (this file)</xsl:when>
									<xsl:when test="contains($mediaType,'mapping')">Mapping Table</xsl:when>
									<xsl:when test="contains($mediaType,'master-document')">Master Document</xsl:when>
									<xsl:when test="contains($mediaType,'transformation')">Transformation</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise>Unknown Type</xsl:otherwise>
						</xsl:choose>
					</td>
					<td>
						<xsl:if test="$item/@ca:pathURI">
							<a>
								<xsl:attribute name="href">
									<xsl:value-of select="$item/@ca:pathURI"/>
								</xsl:attribute>
								<xsl:value-of select="$item/@ca:pathURI"/>
							</a>
						</xsl:if>
					</td>
					<td>
						<xsl:if test="$item/nc:DescriptionText">
							<xsl:value-of select="$item/nc:DescriptionText"/>
						</xsl:if>
						<xsl:if test="$item/@ca:externalURI">
							<xsl:text> (</xsl:text>
							<a>
								<xsl:attribute name="href">
									<xsl:value-of select="$item/@ca:externalURI"/>
								</xsl:attribute>
								<xsl:value-of select="$item/@ca:externalURI"/>
							</a>
							<xsl:text>) </xsl:text>
						</xsl:if>
						<xsl:comment> <xsl:value-of select="concat($itemName,':',$item)"/> </xsl:comment>
					</td>
				</tr>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>

